/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.DynamicTextureLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialModel
implements IModelGeometry<MaterialModel> {
    private static final Logger log = LogManager.getLogger(MaterialModel.class);
    public static final Loader LOADER = new Loader();
    @Nullable
    private final MaterialVariantId material;
    private final int index;
    private final Vec2 offset;

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures = Sets.newHashSet();
        MaterialModel.getMaterialTextures(allTextures, owner, "texture", this.material);
        return allTextures;
    }

    @Deprecated
    public static Predicate<Material> getTextureAdder(Collection<Material> allTextures, boolean logMissingTextures) {
        return DynamicTextureLoader.getTextureAdder(allTextures, logMissingTextures);
    }

    public static void getMaterialTextures(Collection<Material> allTextures, IModelConfiguration owner, String textureName, @Nullable MaterialVariantId material) {
        Material texture = owner.resolveTexture(textureName);
        allTextures.add(texture);
        if (!MissingTextureAtlasSprite.m_118071_().equals((Object)texture.m_119203_())) {
            Predicate<Material> textureAdder = DynamicTextureLoader.getTextureAdder(allTextures, (Boolean)Config.CLIENT.logMissingMaterialTextures.get());
            if (material == null) {
                MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().forEach(info -> info.getTextureDependencies(textureAdder, texture));
            } else {
                MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material).ifPresent(info -> info.getTextureDependencies(textureAdder, texture));
            }
        }
    }

    public static TextureAtlasSprite getPartQuads(Consumer<ImmutableList<BakedQuad>> quadConsumer, IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transform, String name, int index, @Nullable MaterialVariantId material) {
        return MaterialModel.getPartQuads(quadConsumer, owner, spriteGetter, transform, name, index, material, null);
    }

    public static TextureAtlasSprite getPartQuads(Consumer<ImmutableList<BakedQuad>> quadConsumer, IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transform, String name, int index, @Nullable MaterialVariantId material, @Nullable ItemLayerPixels pixels) {
        return MaterialModel.getPartQuads(quadConsumer, owner.resolveTexture(name), spriteGetter, transform, index, material, pixels);
    }

    public static TextureAtlasSprite getPartQuads(Consumer<ImmutableList<BakedQuad>> quadConsumer, Material texture, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transform, int index, @Nullable MaterialVariantId material, @Nullable ItemLayerPixels pixels) {
        Optional<MaterialRenderInfo> optional;
        int color = -1;
        int light = 0;
        TextureAtlasSprite finalSprite = null;
        if (material != null && (optional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material)).isPresent()) {
            MaterialRenderInfo info = optional.get();
            MaterialRenderInfo.TintedSprite sprite = info.getSprite(texture, spriteGetter);
            finalSprite = sprite.sprite();
            color = sprite.color();
            light = info.getLuminosity();
        }
        if (finalSprite == null) {
            finalSprite = spriteGetter.apply(texture);
        }
        quadConsumer.accept((ImmutableList<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)color, (int)index, (TextureAtlasSprite)finalSprite, (Transformation)transform, (int)light, (ItemLayerPixels)pixels));
        return finalSprite;
    }

    private static BakedModel bakeInternal(IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transform, @Nullable MaterialVariantId material, int index, ItemOverrides overrides) {
        MutableObject mutableList = new MutableObject();
        TextureAtlasSprite particle = MaterialModel.getPartQuads(arg_0 -> ((MutableObject)mutableList).setValue(arg_0), owner, spriteGetter, transform, "texture", index, material);
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)owner.getCombinedTransform());
        return new BakedItemModel((ImmutableList)mutableList.getValue(), particle, Maps.immutableEnumMap((Map)transformMap), overrides, true, owner.isSideLit());
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides vanillaOverrides, ResourceLocation modelLocation) {
        Transformation transforms = Vec2.f_82462_.m_82476_(this.offset) ? Transformation.m_121093_() : new Transformation(new Vector3f(this.offset.f_82470_ / 16.0f, -this.offset.f_82471_ / 16.0f, 0.0f), null, null, null);
        ItemOverrides overrides = ItemOverrides.f_111734_;
        if (this.material == null) {
            overrides = new MaterialOverrideHandler(owner, this.index, transforms);
        }
        return MaterialModel.bakeInternal(owner, spriteGetter, transforms, this.material, this.index, overrides);
    }

    public static Vec2 arrayToObject(JsonObject json, String name) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)name);
        if (array.size() != 2) {
            throw new JsonParseException("Expected 2 " + name + " values, found: " + array.size());
        }
        float[] vec = new float[2];
        for (int i = 0; i < 2; ++i) {
            vec[i] = GsonHelper.m_13888_((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return new Vec2(vec[0], vec[1]);
    }

    public MaterialModel(@Nullable MaterialVariantId material, int index, Vec2 offset) {
        this.material = material;
        this.index = index;
        this.offset = offset;
    }

    private static final class MaterialOverrideHandler
    extends ItemOverrides {
        private final Map<MaterialVariantId, BakedModel> cache = new ConcurrentHashMap<MaterialVariantId, BakedModel>();
        private final IModelConfiguration owner;
        private final int index;
        private final Transformation itemTransform;

        private MaterialOverrideHandler(IModelConfiguration owner, int index, Transformation itemTransform) {
            this.owner = owner;
            this.index = index;
            this.itemTransform = itemTransform;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            MaterialVariantId material = IMaterialItem.getMaterialFromStack(stack);
            return this.cache.computeIfAbsent(material, this::bakeDynamic);
        }

        private BakedModel bakeDynamic(MaterialVariantId material) {
            return MaterialModel.bakeInternal(this.owner, ForgeModelBakery.defaultTextureGetter(), this.itemTransform, material, this.index, ItemOverrides.f_111734_);
        }
    }

    private static class Loader
    implements IModelLoader<MaterialModel> {
        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public MaterialModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            int index = GsonHelper.m_13824_((JsonObject)modelContents, (String)"index", (int)0);
            MaterialVariantId material = null;
            if (modelContents.has("material")) {
                material = MaterialVariantId.fromJson(modelContents, "material");
            }
            Vec2 offset = Vec2.f_82462_;
            if (modelContents.has("offset")) {
                offset = MaterialModel.arrayToObject(modelContents, "offset");
            }
            return new MaterialModel(material, index, offset);
        }
    }
}

